function [ H_d_est,H_ref,H_r_est ] = WangZ_ChannelEstimation(Y_1,Y_2,Y_3,options,akt,phint)
%WANGZCHANNELESTIMATION Summary of this function goes here
%   Detailed explanation goes here
%% Phase 1: estimate the channel between the BS and the UE
A_1 = dftmtx(options.K);
H_d_est = Y_1/sqrt(options.Tx_power)*A_1'/options.K;

%% Phase 2: estimate a reference UE 
Phi = dftmtx(options.N);
H_ref = (Y_2/sqrt(options.Tx_power) - H_d_est(:,1)*ones(1,options.N))*Phi'/options.N;

%% Phase 3: estimate all other UEs
% case 1: M>=N
if (options.M>=options.N)
    A_3 = dftmtx(options.K-1);
    Y_3(:,2:options.K) = Y_3(:,2:options.K)*A_3'/(options.K-1);
    H_r_est = zeros(options.N,options.K-1);
    for k = 2:options.K
        H_r_est(:,k-1) = (H_ref'*H_ref)\H_ref'*(Y_3(:,k)/sqrt(options.Tx_power) - H_d_est(:,k));
    end
end
        
% case 2: M<N
if (options.M<options.N)
    T3 = ceil((options.K-1)*options.N/options.M);
    H_r_est = zeros(options.N,options.K-1);
   
    y_bar = Y_3/sqrt(options.Tx_power);
    for t = 1:T3
        for k = 2:options.K
            y_bar(((t-1)*options.M+1):t*options.M) = y_bar(((t-1)*options.M+1):t*options.M) - akt(k,t)*H_d_est(:,k);
        end
    end
    V = zeros(options.M*T3,(options.K-1)*options.N);
    for k = 2:options.K
        for n = 1:options.N
            for t = 1:T3
                V(((t-1)*options.M+1):(t*options.M),n+(k-2)*options.N) = phint(n,t)*akt(k,t)*H_ref(:,n);
            end
        end
    end
    lambda = V\y_bar;
    for k = 1:options.K-1
        H_r_est(:,k) = lambda(((k-1)*options.N+1):(k*options.N));
    end
end

end

